type array α (* a global definition, maybe this is optional *)


module Array = 
  let build = bee_array_build (* build doesn't initialize the array *)
  let length = bee_array_length
  let get = bee_array_get
  let set = bee_array_set
  let blit = bee_array_blit
    
  (* TODO: with make, the array should be initialized to "a" *)
  let make n a = 
    build n

  let copy a = 
    let arr = build (length a) in 
    blit a 0 arr 0 (length a);
    arr
    
  let append a1 a2 = 
    let n1 = length a1 in 
    let n2 = length a2 in 
    let arr = build (n1 + n2) in 
    blit a1 0 arr 0 n1;
    blit a2 0 arr n1 n2;
    arr

  let sub a offset size = 
    if offset + size > length a then (* TODO: can be removed if rich types *)
      print_string "invalid arguments in Array.sub\n";
      error 1
    else
      (let arr = bee_array_build size in 
       bee_array_blit a offset arr 0 size;
       arr)
    
  let fold f accu arr = 
    let result = ref accu in 
    for 0 (length arr - 1)
      (fun i -> (result := f !result arr[i])); (* TODO: extra parenthesis should not be needed *)
    !result
    
  let iter f arr = 
    for 0 (length arr - 1) (fun i -> f arr[i])
    
  let iteri f arr = let _ = fold (fun i a -> let () = f i a in i + 1) 0 arr in ()
  
  let assoc elt arr = fold  (fun b a -> if a = elt then Some a else b)  None  arr


endmodule